using System;
using System.Threading;
using System.Diagnostics;

namespace OrderingClient
{
	
	public class CustomSamplingProcessor : IDisposable
	{
		private PerformanceCounter orderCounter;
		private CounterSample      orderSample;

		private static int curNoOrders = 0;
		private Random rand;

		public CustomSamplingProcessor()
		{
			rand = new Random();

			CounterCreationDataCollection myCounters = new CounterCreationDataCollection();
			
			CounterCreationData myCounterCreationData = new CounterCreationData();
			myCounterCreationData.CounterName = "Order Count";
			myCounterCreationData.CounterHelp = "Displays the number of orders being processed.";
			myCounterCreationData.CounterType = PerformanceCounterType.RateOfCountsPerSecond32;
			myCounters.Add(myCounterCreationData);
			
			if (PerformanceCounterCategory.Exists("Order Processor"))
			{
				PerformanceCounterCategory.Delete("Order Processor");
			}

			PerformanceCounterCategory.Create(
					"Order Processor",
					"OrderProcessor class counters",
					myCounters);

			orderCounter = new PerformanceCounter(
				"Order Processor", 
				"Order Count",
				false);

			orderCounter.RawValue = 0;

			orderSample = new CounterSample();
			orderSample = orderCounter.NextSample();
		}

		public int ProcessOrder()
		{
			Thread th = new Thread(new ThreadStart(doOrder));
			th.Start();

			CurNoOrders++;
			return 0;
		}

		public int CurNoOrders
		{
			get 
			{
				return curNoOrders;
			}
			set 
			{
				curNoOrders = value;
			}
		}

		public float OrderRate
		{
			get 
			{
				CounterSample tempSample = new CounterSample();
				tempSample = orderCounter.NextSample();

				float sample = CounterSample.Calculate(orderSample, tempSample);
				orderSample = tempSample;

				return sample;
			}
		}

		private void doOrder()
		{
			for (int delay = rand.Next(1000000);
				delay >= 0;
				delay--)
				;

			CurNoOrders--;
			orderCounter.Increment();
		}

		public void Dispose() 
		{
			PerformanceCounterCategory.Delete("Order Processor");
		}
	}
}
